using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Options;
using Microsoft.AspNetCore.Http;
using eBilling_Details.Settings;
using eBilling_Details.Models;

namespace eBilling_Details.Areas.CommonPages.Controllers
{
    [Area("CommonPages")]
    public class InvoiceController : Controller
    {
        private readonly string strDBConnection;
        public InvoiceController(IOptions<AppCustomSettings> AppSet)
        {
            var AppCustomSettings = AppSet.Value;
            this.strDBConnection = AppCustomSettings.DBConnectionStrings;
        }


        public IActionResult Index()
        {
            return View();
        }

        public ActionResult pageLoadDetailsInvoiceList()
        {
            string strInsertDetails = string.Empty;
            List<object> objOwnlst = new List<object>(), objOtherlst = new List<object>(), objPendinglst = new List<object>();
            try
            {

                InvoiceDetailsBL objC = new InvoiceDetailsBL(this.strDBConnection);
                objOwnlst = objC.getOwnInvoicelst(Convert.ToInt32(HttpContext.Session.GetString("UserID")));

                objOtherlst = objC.getOtherInvoicelst(Convert.ToInt32(HttpContext.Session.GetString("UserID")));

                objPendinglst = objC.getPendingInvoicelst();

                strInsertDetails = "Done";
            }
            catch (Exception ex)
            {
                strInsertDetails = ex.Message.ToString();
                new ErrorLogging().insertErrorDetails(new ErrorDetails() { dtErrorTime = DateTime.Now, strErrorOriginalDetails = ex.Message, strErrorFunctionName = "public JsonResult GetMenuList()" });
            }
            var myResult = new
            {
                status = strInsertDetails,
                ownlst = objOwnlst,
                otherlst = objOtherlst,
                pendinglst = objPendinglst
            };

            return Ok(myResult);
        }

        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }
    }
}
