using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Options;
using eBilling_Details.Models;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using eBilling_Details.Settings;

namespace eBilling_Details.Areas.CommonPages.Controllers
{
    [Area("CommonPages")]
    //[Authorize(Roles = "superadmin")]
    public class BillingController : Controller
    {
        private readonly string strDBConnection;
        public BillingController(IOptions<AppCustomSettings> AppSet)
        {
            var AppCustomSettings = AppSet.Value;
            this.strDBConnection = AppCustomSettings.DBConnectionStrings;
        }

        public IActionResult PrintInvoice()
        {
            if (HttpContext.Session.GetString("UserID") == null)
                return Redirect("/Home");
            //else if (!HttpContext.Session.GetString("Role").ToString().Equals("1"))
            //    return Redirect("/Home");
            ViewData["NameDTLS"] = HttpContext.Session.GetString("Name");
            //string strPathDetails = HttpContext.Request.QueryString.ToString();//.UrlReferrer.AbsolutePath;
            //string strQVal = HttpContext.Request.Query["orderID"].ToString();
            //ViewData["URLDTLS"] = strPathDetails + " - " + strQVal;
            //ViewData["OrderID"] = strQVal;
            return View();
        }

        public IActionResult Index()
        {
            if (HttpContext.Session.GetString("UserID") == null)
                return Redirect("/Home");
            //else if (!HttpContext.Session.GetString("Role").ToString().Equals("1"))
            //    return Redirect("/Home");
            ViewData["NameDTLS"] = HttpContext.Session.GetString("Name");
            return View();
        }

        public ActionResult addcustomerlst(string strName, string strMobile)
        {
            string strInsertDetails = "Error";
            if (strName == null) strName = string.Empty;
            if (strMobile == null) strMobile = string.Empty;
            string strNameD = Convert.ToString(strName).Trim();
            string strMobileD = Convert.ToString(strMobile).Trim();
            if (!string.IsNullOrEmpty(strNameD.Trim()) && !string.IsNullOrEmpty(strMobileD.Trim()))
            {
                try
                {
                    CustomerDetailsBL objC = new CustomerDetailsBL(this.strDBConnection);
                    objC.AddCustomerDTLS(strNameD.Trim(), strMobileD.Trim());
                    strInsertDetails = "Done";
                }
                catch (Exception ex)
                {
                    strInsertDetails = ex.Message.ToString();
                    new ErrorLogging().insertErrorDetails(new ErrorDetails() { dtErrorTime = DateTime.Now, strErrorOriginalDetails = ex.Message, strErrorFunctionName = "public JsonResult GetMenuList()" });
                }
            }
            var myResult = new { Status = strInsertDetails };
            return Ok(myResult);
        }

        // [Route("getcustomerlst")]
        public ActionResult getcustomerlst(string strName, string strMobile)
        {
            string strInsertDetails = "1";
            List<object> objClst = new List<object>();
            try
            {
                if (strName == null) strName = string.Empty;
                if (strMobile == null) strMobile = string.Empty;

                string strNameD = Convert.ToString(strName).Trim();
                string strMobileD = Convert.ToString(strMobile).Trim();
                // strInsertDetails = "2";
                // if (!string.IsNullOrEmpty(strNameD.Trim()) && !string.IsNullOrEmpty(strMobileD.Trim()))
                //  {
                CustomerDetailsBL objC = new CustomerDetailsBL(this.strDBConnection);
                objClst = objC.getCustomerlst(strNameD.Trim(), strMobileD.Trim());
                // }
                // else
                strInsertDetails = "Done";
            }
            catch (Exception ex)
            {
                strInsertDetails = ex.Message.ToString();
                new ErrorLogging().insertErrorDetails(new ErrorDetails() { dtErrorTime = DateTime.Now, strErrorOriginalDetails = ex.Message, strErrorFunctionName = "public JsonResult GetMenuList()" });
            }
            var myResult = new
            {
                Status = strInsertDetails,
                Cuslst = objClst
            };

            return Ok(myResult);
        }

        public ActionResult getProductlst(int customerID)
        {
            List<object> objPlst = new List<object>(), objCustomerDTLS = new List<object>();
            string strOrderID = string.Empty;
            string strInsertDetails = "Error";
            try
            {
                CustomerDetailsBL objC = new CustomerDetailsBL(this.strDBConnection);
                objCustomerDTLS = objC.getCustomerdtls(customerID);

                ProductDetailsBL objProd = new ProductDetailsBL(this.strDBConnection);
                objPlst = objProd.getProductlst();
                strOrderID = DateTime.Now.ToString("yyyyMMddHHmmss") + HttpContext.Session.GetString("UserID");
                strInsertDetails = "Done";
            }
            catch (Exception ex)
            {
                strInsertDetails = ex.Message.ToString();
                new ErrorLogging().insertErrorDetails(new ErrorDetails() { dtErrorTime = DateTime.Now, strErrorOriginalDetails = ex.Message, strErrorFunctionName = "public JsonResult GetMenuList()" });
            }
            var myResult = new { status = strInsertDetails, prodlst = objPlst, customerdtls = objCustomerDTLS[0], orderiddtls = strOrderID };
            return Ok(myResult);
        }

        public ActionResult getProductdtls(long customerID, int prodid, int qtydtls, long orderid)
        {
            List<ProductAddCardEL> objPlst = new List<ProductAddCardEL>();
            string strInsertDetails = "Error";
            try
            {
                ProductDetailsBL objProd = new ProductDetailsBL(this.strDBConnection);
                objProd.AddProductToCartDetails(prodid, customerID, qtydtls, orderid, Convert.ToInt32(HttpContext.Session.GetString("UserID")));

                objPlst = objProd.getProductDetails(orderid);
                strInsertDetails = "Done";

                // strInsertDetails += "Done" + " - " + objProd.strErrorMessage;
                // strInsertDetails = "Done" + " - " + customerID + " - " + prodid + " - " + qtydtls + " - " + orderid;
            }
            catch (Exception ex)
            {
                strInsertDetails = ex.Message.ToString();
                new ErrorLogging().insertErrorDetails(new ErrorDetails() { dtErrorTime = DateTime.Now, strErrorOriginalDetails = ex.Message, strErrorFunctionName = "public JsonResult GetMenuList()" });
            }
            var myResult = new { status = strInsertDetails, prodlst = objPlst };
            return Ok(myResult);
        }

        public ActionResult removeProductfromcartdtls(int prodid, int qtydtls, long orderid)
        {
            List<ProductAddCardEL> objPlst = new List<ProductAddCardEL>();
            string strInsertDetails = "Error";
            try
            {
                ProductDetailsBL objProd = new ProductDetailsBL(this.strDBConnection);
                objProd.UpdatePsudoProductStock(prodid, qtydtls, orderid, 0);

                objPlst = objProd.getProductDetails(orderid);
                strInsertDetails = "Done";
                // strInsertDetails = "Done" + " - " + prodid + " - " + qtydtls + " - " + orderid;
            }
            catch (Exception ex)
            {
                strInsertDetails = ex.Message.ToString();
                new ErrorLogging().insertErrorDetails(new ErrorDetails() { dtErrorTime = DateTime.Now, strErrorOriginalDetails = ex.Message, strErrorFunctionName = "public JsonResult GetMenuList()" });
            }
            var myResult = new { status = strInsertDetails, prodlst = objPlst };
            return Ok(myResult);
        }

        [HttpPost]
        public ActionResult generateinvoicedtls([FromBody]PaymentPath objpayment)
        {
            //  List<ProductAddCardEL> objPlst = new List<ProductAddCardEL>();
            string strInsertDetails = "Error";
            try
            {
                ProductDetailsBL objProd = new ProductDetailsBL(this.strDBConnection);
                objProd.GenerateInvoiceDetails(objpayment, Convert.ToInt32(HttpContext.Session.GetString("UserID")));

                //   objPlst = objProd.getProductDetails(orderid);
                strInsertDetails = "Done";
                // strInsertDetails = "Done" + " - " + objpayment.card + " - " + objpayment.cash + " - " + " - " + objpayment.paytm + " - " + objpayment.online + " - " + objpayment.orderiddtls;
            }
            catch (Exception ex)
            {
                strInsertDetails = ex.Message.ToString();
                new ErrorLogging().insertErrorDetails(new ErrorDetails() { dtErrorTime = DateTime.Now, strErrorOriginalDetails = ex.Message, strErrorFunctionName = "public JsonResult GetMenuList()" });
            }
            var myResult = new { status = strInsertDetails };
            return Ok(myResult);
        }

        public ActionResult getSavedOrderdtls(long orderid)
        {
            List<ProductAddCardEL> objPlst = new List<ProductAddCardEL>();
            string strInsertDetails = "Error";
            try
            {
                ProductDetailsBL objProd = new ProductDetailsBL(this.strDBConnection);
                objPlst = objProd.getProductDetails(orderid);
                strInsertDetails = "Done";
            }
            catch (Exception ex)
            {
                strInsertDetails = ex.Message.ToString();
                new ErrorLogging().insertErrorDetails(new ErrorDetails() { dtErrorTime = DateTime.Now, strErrorOriginalDetails = ex.Message, strErrorFunctionName = "public JsonResult GetMenuList()" });
            }
            var myResult = new { status = strInsertDetails, prodlst = objPlst };
            return Ok(myResult);
        }

        public ActionResult getInvoiceDetails(string struripath)
        {
            string strInsertDetails = string.Empty;
            List<object> objOrderDTLS = new List<object>(), objProdlstDTLS = new List<object>();
            try
            {
                string strorderIDVal = struripath.Substring(struripath.LastIndexOf("/") + 1);
                InvoiceDetailsBL objC = new InvoiceDetailsBL(this.strDBConnection);
                objOrderDTLS = objC.getInvoiceDetailsFromOrderID(strorderIDVal);
                objProdlstDTLS = objC.getProductListFromOrderID(strorderIDVal);
                strInsertDetails = "Done";
            }
            catch (Exception ex)
            {
                strInsertDetails = ex.Message.ToString();
                new ErrorLogging().insertErrorDetails(new ErrorDetails() { dtErrorTime = DateTime.Now, strErrorOriginalDetails = ex.Message, strErrorFunctionName = "public JsonResult GetMenuList()" });
            }
            var myResult = new
            {
                Status = strInsertDetails,
                prodlst = objProdlstDTLS,
                orderdtls = objOrderDTLS
            };

            return Ok(myResult);
        }

        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }
    }
}
