﻿//var app = angular.module('eBillingPortal', ['ngAnimate', 'ngRoute', 'ui.bootstrap']);
var app = angular.module('eBillingPortal', ['ngAnimate', 'ngRoute', 'ui.bootstrap', 'ngSanitize', 'ui.grid', 'ui.grid.selection', 'ui.grid.cellNav', 'ui.grid.edit']);
app.factory('focus', function ($timeout, $window) {
    return function (id) {
        // timeout makes sure that is invoked after any other event has been triggered.
        // e.g. click events that need to run before the focus or
        // inputs elements that are in a disabled state but are enabled when those events
        // are triggered.
        $timeout(function () {
            var element = $window.document.getElementById(id);
            if (element)
                element.focus();
        });
    };
});
app.directive('eventFocus', function (focus) {
    return function (scope, elem, attr) {
        elem.on(attr.eventFocus, function () {
            focus(attr.eventFocusId);
        });

        // Removes bound events in the element itself
        // when the scope is destroyed
        scope.$on('$destroy', function () {
            element.off(attr.eventFocus);
        });
    };
});
app.controller('counterbillingcreate', ['$scope', '$http', '$templateCache', '$uibModal', '$log', '$timeout', function ($scope, $http, $templateCache, $uibModal, $log, $timeout) {
    $scope.url = "/CommonPages/Billing/";
    $scope.ngerrorDisplay = { errormessage: false, sucessmessage: false };
    $scope.courseItems = { name: null, mobileno: null };
    $scope.objpayment = { card: 0, cash: 0, paytm: 0, online: 0, discount: 0, cashback: 0, orderiddtls: null };
    $scope.ppdetails = { ppcode: null, ppqty: 1 };
    $scope.orderdt = { cupondetails: null };
    $scope.prodseachEnterHitCount = 0;
    $scope.isCustomerDisplay = true;
    $scope.displaycuponerror = false;
    $scope.displaycuponsuccess = false;
    $scope.isProductDisplay = false;
    $scope.isMakeinvoiceDisplay = false;
    $scope.isBillStart = false;
    $scope.isMakeinvoiceStart = false;
    $scope.isMembershipUrgradeRequired = true;
    $scope.isinvoiceCompleteDisplay = false;
    $scope.iscompleteinvoice = false;
    $scope.billProductlst = [];
    $scope.mySelectedRows = []; // Customer details
    $scope.prodSelectedRows = [];
    $scope.inttotalsgst = 0; $scope.inttotaligst = 0; $scope.inttotalfinalamount = 0; $scope.intPendingtotalamount = 0;
    $scope.intPaidtotalamount = 0; $scope.totalqty = 0;
    $scope.gridcustomerlst = {
        enableRowSelection: false,
        enableSelectAll: false,
        enableFiltering: true,
        selectionRowHeaderWidth: 35,
        rowHeight: 25,
        showGridFooter: false,
        enableColumnResizing: false,
        // paginationPageSizes: [10, 15, 20],
        //  paginationPageSize: 10,
        enableFiltering: false
    };
    var selectionCellTemplate = '<div class="ngCellText ui-grid-cell-contents">' +
        ' <div ng-click="grid.appScope.rowClick(row)">{{row.entity.name}}</div>' +
        '</div>';
    $scope.gridcustomerlst.columnDefs = [
        { name: 'id', displayName: 'Id', width: 50, visible: false },
        { name: 'name', displayName: 'Name', cellTemplate: selectionCellTemplate },
        { name: 'mobileno', displayName: 'Mobile' }
    ];

    $scope.gridcustomerlst.multiSelect = false;
    $scope.gridcustomerlst.onRegisterApi = function (gridApi) {
        $scope.gridApi = gridApi;
        
        //$scope.gridApi.selection.on.rowSelectionChanged($scope, function (row) {
        //    if (row.isSelected) {
        //        $scope.mySelectedRows = $scope.gridApi.selection.getSelectedRows();
        //        $scope.updateAfterCustomerSelect();
        //    }
        //    else
        //        $scope.mySelectedRows = [];
        //});
    };

    $scope.rowClick = function (row) {
        var index = row.grid.renderContainers.body.visibleRowCache.indexOf(row);
        $scope.gridApi.selection.selectRow($scope.gridcustomerlst.data[index]);
        $scope.mySelectedRows = $scope.gridApi.selection.getSelectedRows();
              $scope.updateAfterCustomerSelect();
       // $log.log(index);
    };

    $scope.txtMobileKeyUp = function () {
        var k;
        // $log.log(event.keyCode);
        if (event.keyCode) {
            k = event.keyCode;
            if (k == 13) //Enter
            {
                $scope.mySelectedRows = $scope.gridApi.selection.getSelectedRows();
                $scope.updateAfterCustomerSelect();
            }
            else
                $scope.btnSearchCustomer();
        }
    };
    $scope.txtNameKeyUp = function () { $scope.txtMobileKeyUp(); };
    $scope.btnSearchCustomer = function () {
        $http({ method: 'POST', url: $scope.url + 'getcustomerlst', cache: $templateCache, params: { strName: $scope.objcustomer.name, strMobile: $scope.objcustomer.mobileno } }).then(successCallbackSess, errorCallbackSess);
    }

    function successCallbackSess(response) {
        $scope.gridcustomerlst.data = response.data.cuslst;
        // ----------------------------
        $scope.gridApi.grid.modifyRows($scope.gridcustomerlst.data);
        $scope.gridApi.selection.selectRow($scope.gridcustomerlst.data[0]);
        // -------------------------------
    }
    function errorCallbackSess(error) { }

    $scope.btnAddCustomer = function () {
        var cname = $scope.objcustomer.name;
        if (isNullorEmpty($scope.objcustomer.name))
            cname = $scope.objcustomer.mobileno;
        $http({ method: 'POST', url: $scope.url + 'addcustomerlst', cache: $templateCache, params: { strName: cname, strMobile: $scope.objcustomer.mobileno } }).then(successCallbackAdd, errorCallbackAdd);
    }
    function successCallbackAdd(response) {
        $scope.mySelectedRows = response.data.cuslst;
        $scope.updateAfterCustomerSelect();
    }
    function errorCallbackAdd(error) { }

    $scope.updateAfterCustomerSelect = function () {
        $scope.isCustomerDisplay = false;
        $scope.isProductDisplay = true;
        $scope.isInitStart = true;
        $scope.isBillStart = true;
        // $("#txtppcode").focus();
        // $window.document.getElementById('txtppcode').focus();
        //  $scope.gridApiPL.core.refresh();
        $http({ method: 'POST', url: $scope.url + 'getProductlst', cache: $templateCache, params: { customerID: $scope.mySelectedRows[0].id } }).then(sucCallbackPlst, errCallbackPlst);
    };
    $scope.$watch('isProductDisplay', function (newValue, oldValue, scope) {
        // $log.log("- - No focus call");
        // $("#txtppcode").focus();
        //$window.document.getElementById('txtppcode').
        $scope.setProductCodeFocus(1);
    });
    $scope.setProductCodeFocus = function (id) {
        // $log.log("call - " + id);
        focus("txtppcode");
    }
    // ==================================================================
    $scope.gridproductlst = {
        enableRowSelection: false,
        enableSelectAll: false,
        // enableFiltering: true,
        selectionRowHeaderWidth: 35,
        rowHeight: 50,
        showGridFooter: false,
        enableColumnResizing: false,
        // paginationPageSizes: [10, 15, 20],
        //  paginationPageSize: 10,
        enableFiltering: true
    };
    var positionTemplate = '<div class="ui-grid-cell-contents"><input type="text" ng-model="row.entity.qtydtls" class="form-control" /></div>';
    var actionTemplate = '<div class="ui-grid-cell-contents"><button type="button" class="btn btn-sm btn-primary btn-circle" ng-click="grid.appScope.addProductDetailstocart(row.entity)">+</button></div>';

    var proddtlsTemplate = '<div class="ui-grid-cell-contents"><div ng-bind-html="row.entity.proddtls"></div></div>';

    $scope.gridproductlst.columnDefs = [
        { name: 'id', displayName: 'Id', width: 50, visible: false },
        { name: 'prodcode', displayName: 'Code', width: 120 },//, visible: false },
        { name: 'proddtls', displayName: 'Details', cellTemplate: proddtlsTemplate },
        { name: 'qtydtls', displayName: 'Qty.', width: 60, cellTemplate: positionTemplate, enableFiltering: false },
        { field: 'e', displayName: '#', width: 60, cellTemplate: actionTemplate, enableFiltering: false }
    ];

    $scope.gridproductlst.multiSelect = false;
    $scope.gridproductlst.onRegisterApi = function (gridApi) {
        $scope.gridApiPL = gridApi;
        $scope.gridApiPL.selection.on.rowSelectionChanged($scope, function (row) {
            if (row.isSelected) {
                $scope.prodSelectedRows = $scope.gridApiPL.selection.getSelectedRows();
                // $scope.updateAfterCustomerSelect();
            }
            else
                $scope.prodSelectedRows = [];
        });
    };
    function sucCallbackPlst(response) {
        $scope.allproductlst = response.data.prodlst;
        $scope.gridproductlst.data = $scope.allproductlst;
        $scope.customerDTLS = response.data.customerdtls;
        $scope.orderiddtls = response.data.orderiddtls;

        // ----------------------------
        $timeout(function () {
            $scope.gridApiPL.grid.modifyRows($scope.gridproductlst.data);
            $scope.gridApiPL.selection.selectRow($scope.gridproductlst.data[0]);

            $scope.setProductCodeFocus(2);

            if ($scope.customerDTLS.isClubMem == "No")
                $scope.isMembershipUrgradeRequired = false;
        });
        // -------------------------------


    }
    function errCallbackPlst(error) { }
    //==================================================================
    $scope.enterKeyHitbyUser = function () {
        if (isNullorEmpty($scope.ppdetails.ppcode) && ($scope.prodseachEnterHitCount > 0)) { alert("Search product first!"); return; }

        if (($scope.prodSelectedRows.length > 0)
            && isNullorEmpty($scope.ppdetails.ppcode)
            && $scope.ppdetails.ppqty > 0) {
            $scope.addProducttoCartDetails();
            $scope.prodSelectedRows = [];
        }
        else if (($scope.prodSelectedRows.length == 0)
            && !isNullorEmpty($scope.ppdetails.ppcode)
            && $scope.ppdetails.ppqty > 0) {
            $scope.searchProductFromProductCode();
        }
        else if (($scope.prodSelectedRows.length > 0)
            && !isNullorEmpty($scope.ppdetails.ppcode)
            && $scope.ppdetails.ppqty > 0) {
            var prodCode = $scope.prodSelectedRows[0].prodcode;
            if (prodCode.includes($scope.ppdetails.ppcode)) {
                $scope.addProducttoCartDetails();
                $scope.prodSelectedRows = [];
            } else { $scope.searchProductFromProductCode(); }
        }
    };

    $scope.txtproductsearchKeyUp = function () {
        $log.log($scope.ppdetails.ppcode + " - " + event.keyCode + " - " + $scope.prodseachEnterHitCount + " - " + $scope.prodSelectedRows.length);
        var k;
        if (event.keyCode) {
            k = event.keyCode;
            if (k == 13) {
                $scope.prodseachEnterHitCount++;
                $scope.enterKeyHitbyUser();
            }
            //if (!isNullorEmpty($scope.ppdetails.ppcode)) {
            //    if ((k == 13) && ($scope.prodseachEnterHitCount == 0)) //1st Enter
            //    {
            //        $scope.prodseachEnterHitCount++;
            //        // $scope.prodSelectedRows = $scope.gridApiPL.selection.getSelectedRows();
            //        $scope.searchProductFromProductCode();
            //    }
            //    else if ((k == 13) && ($scope.prodseachEnterHitCount == 1)) //2nd Enter
            //    {
            //        $scope.prodseachEnterHitCount++;
            //        $scope.prodSelectedRows = $scope.gridApiPL.selection.getSelectedRows();
            //        $scope.addProducttoCartDetails();
            //    }
            //}
        }
    };
    $scope.searchProductFromProductCode = function () {
        $http({ method: 'POST', url: $scope.url + 'getProductlstfrmcode', cache: $templateCache, params: { prodcode: $scope.ppdetails.ppcode } }).then(sucSPCallbackPlst, errSPCallbackPlst);
    };
    function sucSPCallbackPlst(response) {
        // $scope.allproductlst = response.data.prodlst;
        $scope.gridproductlst.data = response.data.prodlst;
        // ----------------------------
        $timeout(function () {
            $scope.gridApiPL.grid.modifyRows($scope.gridproductlst.data);
            $scope.gridApiPL.selection.selectRow($scope.gridproductlst.data[0]);
        });
    }
    function errSPCallbackPlst(error) { }
    $scope.addProducttoCartDetails = function () {
        if ($scope.prodSelectedRows.length > 0) {
            $scope.prodSelectedRows[0].qtydtls = $scope.ppdetails.ppqty;
            $scope.addProductDetailstocart($scope.prodSelectedRows[0]);
            //---------------------------------------

        }
        else { $scope.prodseachEnterHitCount = 0; }
    };
    $scope.updateproductlsttoAdd = function () {
        $scope.prodseachEnterHitCount = 0;
        $scope.ppdetails.ppcode = null; $scope.ppdetails.ppqty = 1; $scope.setProductCodeFocus(3);
        $scope.prodSelectedRows = [];
        $scope.gridproductlst.data = $scope.allproductlst;
        // ----------------------------
        $timeout(function () {
            $scope.gridApiPL.grid.modifyRows($scope.gridproductlst.data);
            $scope.gridApiPL.selection.selectRow($scope.gridproductlst.data[0]);
        });
    };
    // ==================================================================
    $scope.checkAlreadyAddedDetails = function (row) {
        var isOkay = false;
      //  var maxbuylimit = row.buylimit;
        var cartqty = 0; var totalqty = 0;      
        $.each($scope.billProductlst, function (index, value) {           
            if ($scope.billProductlst[index].prodcode == row.prodcode) { cartqty = $scope.billProductlst[index].qty } ;
        });
        totalqty = (parseInt(cartqty) + parseInt(row.qtydtls));
        if (parseInt(totalqty) > parseInt(row.buylimit)) { isOkay = true; }       
        return isOkay;
    };

    $scope.addProductDetailstocart = function (row) {
        //  $log.log(row);
        if (parseInt(row.qtydtls) > parseInt(row.prodstock)) { alert("Maximum " + row.prodstock + " you can add!"); }
        else if (parseInt(row.qtydtls) > parseInt(row.buylimit)) { alert("Maximum " + row.buylimit + " you can add!"); }
        else if ($scope.checkAlreadyAddedDetails(row)) { alert("Maximum " + row.buylimit + " you can add!"); }
        else {
            $http({ method: 'POST', url: $scope.url + 'getProductdtls', cache: $templateCache, params: { customerID: $scope.mySelectedRows[0].customerid, prodid: row.id, qtydtls: row.qtydtls, orderid: $scope.orderiddtls } }).then(sucCallbackPdtls, errCallbackPdtls);
        }
    };

    $scope.btnUpdateMembership = function () {
        $scope.items = { orderID: null, customerdtls: null };
        $scope.items.orderID = $scope.orderiddtls;
        $scope.items.customerdtls = $scope.customerDTLS;
        // $log.info('Open Popup: ' + new Date());
        var modalInstance = $uibModal.open({
            templateUrl: 'updatecustomerMembershipContent.html',
            controller: 'updatecustmembershipContent',
            backdrop: 'static',
            keyboard: false,
            size: 'lg',
            resolve: {
                items: function () {
                    return $scope.items; //$scope.customerDTLS;// $scope.items;
                }
            }
        });

        modalInstance.result.then(function (selectedItems) {
            //if (!isNullorEmpty(selectedItems)) {
            //    // $scope.orderdtls.customerdtls.deliveryaddress = selectedItems;
            //}
            $scope.fetchBillingData($scope.orderiddtls);
           // $scope.reloadorderdetailsgrid();
        }, function () {
            $log.info('Modal dismissed at: ' + new Date());
        });


    };
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    $scope.reloadorderdetailsgrid = function () {


    };

    $scope.gridBilinglst = {
        enableRowSelection: false,
        enableSelectAll: false,
        enableFiltering: true,
        selectionRowHeaderWidth: 35,
        rowHeight: 25,
        showGridFooter: false,
        enableColumnResizing: false,
        // paginationPageSizes: [10, 15, 20],
        //  paginationPageSize: 10,
        enableFiltering: true
    };
    // var positionTemplate = '<div class="ui-grid-cell-contents"><input type="text" ng-model="row.entity.qtydtls" class="form-control" /></div>';
    var actionBTemplate = '<div class="ui-grid-cell-contents"><button type="button" class="btn btn-sm btn-danger btn-circle" ng-click="grid.appScope.removeProductDetailsfromcart(row.entity)">-</button></div>';

    $scope.gridBilinglst.columnDefs = [
        { name: 'id', displayName: 'Id', width: 50, visible: false },
        { name: 'slno', displayName: 'S#', width: 45, enableFiltering: false, cellTemplate: '<div class="ui-grid-cell-contents">{{grid.renderContainers.body.visibleRowCache.indexOf(row) +1}}</div>' },
        { name: 'prodcode', displayName: 'Code', width: 90 },
        { name: 'productName', displayName: 'Product', cellTemplate: '<div class="ui-grid-cell-contents"><div ng-bind-html="row.entity.productName"></div></div>' },
        { name: 'rate', displayName: 'Rate', width: 90, enableFiltering: false },
        { name: 'price', displayName: 'Price', width: 90, enableFiltering: false },
        { name: 'cgst', displayName: 'CGST', width: 90, enableFiltering: false },
        { name: 'sgst', displayName: 'SGST', width: 90, enableFiltering: false },
        { name: 'igst', displayName: 'IGST', width: 90, enableFiltering: false },
        { name: 'qty', displayName: 'Qty', width: 90 },
        { name: 'amount', displayName: 'Amount', width: 90 },
        // { name: 'qtydtls', displayName: 'Qty.', width: 90, cellTemplate: positionTemplate },
        { field: 'e', displayName: 'Action', width: 90, cellTemplate: actionBTemplate }
    ];

    $scope.gridBilinglst.multiSelect = false;
    $scope.gridBilinglst.onRegisterApi = function (gridApi) { };

    function sucCallbackPdtls(response) {
        // $scope.billProductlst.push(response.data.prodlst);
        $scope.billProductlst = response.data.prodlst;
        $scope.gridBilinglst.data = $scope.billProductlst;
        $scope.updateproductlsttoAdd();
        $scope.updateTotalAmountDetails();
    }
    function errCallbackPdtls(error) { }

    $scope.removeProductDetailsfromcart = function (row) {
        // $scope.billProductlst.splice($scope.billProductlst.indexOf(row), 1);
        $http({ method: 'POST', url: $scope.url + 'removeProductfromcartdtls', cache: $templateCache, params: { prodid: row.id, qtydtls: row.qty, orderid: $scope.orderiddtls } }).then(sucCallbackPRdtls, errCallbackPRdtls);
        // $scope.updateTotalAmountDetails();
    };
    function sucCallbackPRdtls(response) {
        $scope.billProductlst = response.data.prodlst;
        $scope.gridBilinglst.data = $scope.billProductlst;
        $scope.updateTotalAmountDetails();
    }
    function errCallbackPRdtls(error) { }

    $scope.inttotalcgst = 0;
    $scope.updateTotalAmountDetails = function () {
        $timeout(function () {
            var inttotalcgst = 0; var inttotalsgst = 0; var inttotaligst = 0; var inttotalfinalamount = 0
            var intTotalqty = 0;
            $.each($scope.billProductlst, function (index, value) {
                inttotalcgst += parseFloat($scope.billProductlst[index].cgst);//.toFixed(2);
                inttotalsgst += parseFloat($scope.billProductlst[index].sgst);//.toFixed(2);
                inttotaligst += parseFloat($scope.billProductlst[index].igst);//.toFixed(2);
                inttotalfinalamount += parseFloat($scope.billProductlst[index].amount);//.toFixed(2);
                intTotalqty += parseInt($scope.billProductlst[index].qty);
            });

            $scope.inttotalcgst = inttotalcgst;// parseFloat($scope.billProductlst[index].cgst).toFixed(2);
            $scope.inttotalsgst = inttotalsgst;// parseFloat($scope.billProductlst[index].sgst).toFixed(2);
            $scope.inttotaligst = inttotaligst; // parseFloat($scope.billProductlst[index].igst).toFixed(2);
            $scope.inttotalfinalamount = inttotalfinalamount; // parseFloat($scope.billProductlst[index].amount).toFixed(2);

            $scope.intPendingtotalamount = ($scope.inttotalfinalamount - $scope.intPaidtotalamount);
            $scope.totalqty = intTotalqty;
        });
    };
    $scope.gridBilinglstf = {
        enableRowSelection: false,
        enableSelectAll: false,
       // enableFiltering: true,
        selectionRowHeaderWidth: 35,
        rowHeight: 25,
        showGridFooter: false,
        enableColumnResizing: false,
        // paginationPageSizes: [10, 15, 20],
        //  paginationPageSize: 10,
        enableFiltering: false
    };
    $scope.gridBilinglstf.columnDefs = [
        { name: 'id', displayName: 'Id', width: 50, visible: false },
        { name: 'slno', displayName: 'S#', width: 45, cellTemplate: '<div class="ui-grid-cell-contents">{{grid.renderContainers.body.visibleRowCache.indexOf(row) +1}}</div>' },
        { name: 'productName', displayName: 'Product' },
        { name: 'rate', displayName: 'Rate', width: 90 },
        { name: 'price', displayName: 'Price', width: 90 },
        { name: 'cgst', displayName: 'CGST', width: 90 },
        { name: 'sgst', displayName: 'SGST', width: 90 },
        { name: 'igst', displayName: 'IGST', width: 90 },
        { name: 'qty', displayName: 'Qty', width: 90 },
        { name: 'amount', displayName: 'Amount', width: 90 }
    ];

    $scope.gridBilinglstf.multiSelect = false;
    $scope.gridBilinglstf.onRegisterApi = function (gridApi) { };
    $scope.makeinvoiceDetails = function () {
        $scope.isCustomerDisplay = false;
        $scope.isProductDisplay = false;
        $scope.isMakeinvoiceDisplay = true;
        $scope.isMakeinvoiceStart = true;
        $scope.gridBilinglstf.data = $scope.billProductlst;
    };

    $scope.btnAddNewProducttocart = function () {
        $scope.isProductDisplay = true;
        $scope.isMakeinvoiceDisplay = false;
    };
    $scope.updatePaymentProperty = function () {
        if (isNullorEmpty($scope.objpayment.card)) $scope.objpayment.card = 0;
        if (isNullorEmpty($scope.objpayment.cash)) $scope.objpayment.cash = 0;
        if (isNullorEmpty($scope.objpayment.paytm)) $scope.objpayment.paytm = 0;
        if (isNullorEmpty($scope.objpayment.online)) $scope.objpayment.online = 0;
    };
    //-----------------------------------------
    $scope.btnApplyCupon = function () {
        if (!isNullorEmpty($scope.orderdt.cupondetails)) {
            $http({ method: 'POST', url: $scope.url + 'applycuponcodedtls', cache: $templateCache, params: { strcupondtls: $scope.orderdt.cupondetails, strorderid: $scope.orderiddtls } }).then(successAppCuponcode, errorAppCuponcode);
        }
        else
            alert("Cupon code can not empty!");
    };
    function successAppCuponcode(response) {
       // $log.log(response.data);
        $scope.displaycuponerror = false;
        $scope.displaycuponsuccess = false;
        $scope.cupondtlsval = response.data.cupondtlsval;
        $scope.billProductlst = response.data.prodlst;
        $scope.gridBilinglstf.data = $scope.billProductlst;
        if (!isNullorEmpty($scope.cupondtlsval.errormsgdetails)) {
            $scope.displaycuponerror = true;
            $scope.objpayment.discount = 0;
            $scope.objpayment.cashback = 0;
            $scope.updatePaymentDTLS();
        }
        else {
            $scope.displaycuponsuccess = true;
            $scope.objpayment.discount = parseInt($scope.cupondtlsval.discountamount);
            $scope.objpayment.cashback = parseInt($scope.cupondtlsval.cashbackamount);
            $scope.updatePaymentDTLS();
        }


        //  $scope.objcustomeraddlst = response.data.addresslst;
    }
    function errorAppCuponcode(error) { }
    // -------------------------------------------

    $scope.txtpaymentKeyUp = function () { $scope.updatePaymentProperty(); $scope.updatePaymentDTLS(); };
    $scope.updatePaymentDTLS = function () {
        $scope.intPaidtotalamount = (parseFloat($scope.objpayment.card) + parseFloat($scope.objpayment.cash) +
            parseFloat($scope.objpayment.paytm) + parseFloat($scope.objpayment.online) +
            parseFloat($scope.objpayment.cashback));

        $scope.intPendingtotalamount = ($scope.inttotalfinalamount - $scope.intPaidtotalamount);
    };

    $scope.fetchBillingData = function (intOrderID) {

        //if ($scope.intPaidtotalamount == $scope.inttotalfinalamount)
        $scope.orderiddtls = intOrderID;
        $http({ method: 'POST', url: $scope.url + 'getSavedOrderdtls', cache: $templateCache, params: { orderid: $scope.orderiddtls } }).then(successCallbacksaveorder, errorCallbacksaveorders);
        //else
        //    alert("Payment Not complete!");
    };
    function successCallbacksaveorder(response) {
        $log.log(response.data);
        $scope.billProductlst = response.data.prodlst;
        $scope.gridBilinglst.data = $scope.billProductlst;
        // -----------------------
        $scope.displaycuponerror = false;
        $scope.displaycuponsuccess = false;
        $scope.cupondtlsval = response.data.cupondtlsval;  
        if (!isNullorEmpty($scope.cupondtlsval.cupondtls)) {
            if (!isNullorEmpty($scope.cupondtlsval.errormsgdetails)) {
                $scope.displaycuponerror = true;
                $scope.objpayment.discount = 0;
                $scope.objpayment.cashback = 0;
                $scope.updatePaymentDTLS();
            }
            else {
                $scope.displaycuponsuccess = true;
                $scope.objpayment.discount = parseInt($scope.cupondtlsval.discountamount);
                $scope.objpayment.cashback = parseInt($scope.cupondtlsval.cashbackamount);
                $scope.orderdt.cupondetails = $scope.cupondtlsval.cupondtls;
                $scope.updatePaymentDTLS();
            }
        }
        //--------------------------
        $scope.updateTotalAmountDetails();
    }
    function errorCallbacksaveorders(error) { }
    $scope.btnInvoiceGeneration = function () {
        if ($scope.intPaidtotalamount == $scope.inttotalfinalamount) {
            //var paymentd = new Object();
            //paymentd.card = parseInt($scope.objpayment.card);
            //paymentd.cash = parseInt($scope.objpayment.cash);
            //paymentd.paytm = parseInt($scope.objpayment.paytm);
            //paymentd.online = parseInt($scope.objpayment.online);
            //$scope.objpaymentdtlss = { card: 0, cash: 0, paytm: 0, online: 0 };

            $scope.objpayment.card = parseInt($scope.objpayment.card);
            $scope.objpayment.cash = parseInt($scope.objpayment.cash);
            $scope.objpayment.paytm = parseInt($scope.objpayment.paytm);
            $scope.objpayment.online = parseInt($scope.objpayment.online);
            $scope.objpayment.orderiddtls = $scope.orderiddtls;
            $http({
                method: 'POST',
                dataType: 'json',
                url: $scope.url + 'generateinvoicedtls',
                cache: $templateCache,
                //  params: { orderid: $scope.orderiddtls, objpayment: JSON.stringify(paymentd) }
                data: JSON.stringify($scope.objpayment)
                // headers: {"Content-Type":"application/json"}
            }).then(successCallbackgin, errorCallbackgin);

            //var options = {};
            //options.url = $scope.url + "generateinvoicedtls";
            //options.type = "POST";
            //options.contentType = "application/json";
            //options.data = JSON.stringify(paymentd);
            //options.dataType = "json";
            //options.success = function (msg) { $log.log(msg); };
            //options.error = function (msg) { $log.log(msg); };
            //$.ajax(options);
        }
        else
            alert("Payment Not complete!");
    };
    function successCallbackgin(response) {
        // var fsf = response.data;
        // $scope.billProductlst = response.data.prodlst;
        //$scope.gridBilinglst.data = $scope.billProductlst;
        //$scope.updateTotalAmountDetails();
        if (response.data.status = "Done") {
            $scope.isinvoiceCompleteDisplay = true;
            $scope.isMakeinvoiceDisplay = false;
            $scope.iscompleteinvoice = true;
            $scope.gridBilinglstfi.data = $scope.billProductlst;
            $scope.printInvoice();
        }
    }
    function errorCallbackgin(error) { }

    $scope.printInvoice = function () {
        //  var strURL = "/CommonPages/Billing/PrintInvoice?orderID=" + $scope.orderiddtls;       
        var strURL = "/CommonPages/Billing/PrintInvoice/" + $scope.orderiddtls;
        window.open(strURL, "print");
    };

    $scope.closethisWindow = function () {
        //  window.opener.gotoListPage();
        window.opener.location.reload(true);
        self.close();
    };

    $scope.btnStartNewClick = function () {
        location.reload(true);
    };


    $scope.gridBilinglstfi = {
        enableRowSelection: false,
        enableSelectAll: false,
        enableFiltering: true,
        selectionRowHeaderWidth: 35,
        rowHeight: 25,
        showGridFooter: false,
        enableColumnResizing: false,
        // paginationPageSizes: [10, 15, 20],
        //  paginationPageSize: 10,
        enableFiltering: true
    };
    $scope.gridBilinglstfi.columnDefs = [
        { name: 'id', displayName: 'Id', width: 50, visible: false },
        { name: 'slno', displayName: 'S#', width: 45, cellTemplate: '<div class="ui-grid-cell-contents">{{grid.renderContainers.body.visibleRowCache.indexOf(row) +1}}</div>' },
        { name: 'productName', displayName: 'Product' },
        { name: 'rate', displayName: 'Rate', width: 90 },
        { name: 'price', displayName: 'Price', width: 90 },
        { name: 'cgst', displayName: 'CGST', width: 90 },
        { name: 'sgst', displayName: 'SGST', width: 90 },
        { name: 'igst', displayName: 'IGST', width: 90 },
        { name: 'qty', displayName: 'Qty', width: 90 },
        { name: 'amount', displayName: 'Amount', width: 90 }
    ];

    $scope.gridBilinglstfi.multiSelect = false;
    $scope.gridBilinglstfi.onRegisterApi = function (gridApi) { };
}]);
